<?php
// Folder to store iOS USDZ models
$folder = 'iosModels/';

// Create folder if not exists
if (!is_dir($folder)) {
    mkdir($folder, 0777, true);
}

// Check if file is received
if (!isset($_FILES['file2'])) {
    echo "ERROR: No file received.";
    exit();
}

// File data
$fileName     = $_FILES["file2"]["name"];
$fileTmpLoc   = $_FILES["file2"]["tmp_name"];
$fileError    = $_FILES["file2"]["error"];
$fileExt      = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

// Validate extension
if ($fileExt !== "usdz") {
    echo "ERROR: Only .usdz files allowed.";
    exit();
}

// Ensure an actual file was uploaded
if (!$fileTmpLoc || $fileError !== 0) {
    echo "ERROR: Upload failed.";
    exit();
}

// Generate unique filename
$newName = time() . "_" . preg_replace("/[^A-Za-z0-9.\-_]/", "", $fileName);

// Move file
if (move_uploaded_file($fileTmpLoc, $folder . $newName)) {
    echo $newName; // return ONLY filename
} else {
    echo "ERROR: Failed to save file.";
}
?>