<?php
// Folder to store Android GLB models
$folder = 'androidModels/';

// Create folder if not exists
if (!is_dir($folder)) {
    mkdir($folder, 0777, true);
}

// Check if file is received
if (!isset($_FILES['file1'])) {
    echo "ERROR: No file received.";
    exit();
}

// File data
$fileName     = $_FILES["file1"]["name"];
$fileTmpLoc   = $_FILES["file1"]["tmp_name"];
$fileError    = $_FILES["file1"]["error"];
$fileExt      = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

// Validate extension
if ($fileExt !== "glb") {
    echo "ERROR: Only .glb files allowed.";
    exit();
}

// Ensure an actual file was uploaded
if (!$fileTmpLoc || $fileError !== 0) {
    echo "ERROR: Upload failed.";
    exit();
}

// Generate unique filename
$newName = time() . "_" . preg_replace("/[^A-Za-z0-9.\-_]/", "", $fileName);

// Move file
if (move_uploaded_file($fileTmpLoc, $folder . $newName)) {
    echo $newName; // return ONLY filename
} else {
    echo "ERROR: Failed to save file.";
}
?>