<?php 
$model = $_GET['model'];
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <!-- We've included a slightly modified version of A-Frame, which fixes some polish concerns -->
    <script src="https://aframe.io/releases/1.0.4/aframe.min.js"></script>
    <script src="https://raw.githack.com/AR-js-org/AR.js/master/aframe/build/aframe-ar.js"></script>
    <script src="https://cdn.rawgit.com/donmccurdy/aframe-extras/cfe5f316/dist/aframe-extras.js"></script>
    <script src="js/gesture-detector.js"></script>
    <script src="js/pinch-scale.js"></script>
    <script src="js/two-finger-spin.js"></script>
    <script>
        AFRAME.components["look-controls"].Component.prototype.onTouchMove = function (t) {
                        var PI_2 = Math.PI/2,
                        e,
                        o = this.el.sceneEl.canvas,
                        i = this.yawObject,
                        j = this.pitchObject;
                        this.touchStarted && this.data.touchEnabled && (e = 2 * Math.PI * (t.touches[0].pageX - this.touchStart.x) / o.clientWidth, f = 2 * Math.PI * (t.touches[0].pageY - this.touchStart.y) / o.clientHeight, j.rotation.x += .3 * f, i.rotation.y += .5 * e, j.rotation.x = Math.max(-PI_2, Math.min(PI_2, j.rotation.x)), this.touchStart = {
                                x: t.touches[0].pageX,
                                y: t.touches[0].pageY
                            })
                        }
    </script>
  </head>

  <body>
    <a-scene embedded arjs='sourceType: webcam;' renderer="logarithmicDepthBuffer: true;antialias: true; alpha: true; precision: mediump;" gesture-detector>
<!-- We can define assets here to be loaded when A-Frame initializes -->
      <a-assets>
        <a-asset-item id="sandCastleModel" src="androidModels/<?php echo $model; ?>"></a-asset-item> 
      </a-assets>

      <!-- The raycaster will emit mouse events on scene objects specified with the cantap class -->
      <a-camera
        id="camera"
        position="0 8 8"
        raycaster="objects: .cantap"
        cursor="
          fuse: false;
          rayOrigin: mouse;">
      </a-camera>

      <a-entity
        light="type: directional;
               intensity: 0.8;"
        position="1 4.3 2.5">
      </a-entity>

      <a-light type="ambient" intensity="1"></a-light>

      <a-entity gltf-model="#sandCastleModel" class="cantap" two-finger-spin pinch-scale scale="1 1 1"></a-entity>
      <a-entity
        id="ground"
        class="cantap"
        geometry="primitive: box"
        material="color: #ffffff; transparent: true; opacity: 0.0"
        scale="1000 2 1000"
        position="0 -1 0">
      </a-entity>
    </a-scene>
  </body>
</html>